<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LgAttribute;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LgAttributeController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('lg_attribute_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute.index');
    }

    public function create()
    {
        abort_if(Gate::denies('lg_attribute_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute.create');
    }

    public function edit(LgAttribute $lgAttribute)
    {
        abort_if(Gate::denies('lg_attribute_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.lg-attribute.edit', compact('lgAttribute'));
    }

    public function show(LgAttribute $lgAttribute)
    {
        abort_if(Gate::denies('lg_attribute_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $lgAttribute->load('ledgerGroup');

        return view('admin.lg-attribute.show', compact('lgAttribute'));
    }
}
