<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\LedgerLgAttributeValue;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LedgerLgAttributeValueController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('ledger_lg_attribute_value_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-lg-attribute-value.index');
    }

    public function create()
    {
        abort_if(Gate::denies('ledger_lg_attribute_value_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-lg-attribute-value.create');
    }

    public function edit(LedgerLgAttributeValue $ledgerLgAttributeValue)
    {
        abort_if(Gate::denies('ledger_lg_attribute_value_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-lg-attribute-value.edit', compact('ledgerLgAttributeValue'));
    }

    public function show(LedgerLgAttributeValue $ledgerLgAttributeValue)
    {
        abort_if(Gate::denies('ledger_lg_attribute_value_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $ledgerLgAttributeValue->load('ledger', 'lgAttribute', 'lgAttributeValue');

        return view('admin.ledger-lg-attribute-value.show', compact('ledgerLgAttributeValue'));
    }
}
