<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\LedgerGroup;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class LedgerGroupController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = LedgerGroup::class;
    }

    public function index()
    {
        abort_if(Gate::denies('ledger_group_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-group.index');
    }

    public function create()
    {
        abort_if(Gate::denies('ledger_group_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-group.create');
    }

    public function edit(LedgerGroup $ledgerGroup)
    {
        abort_if(Gate::denies('ledger_group_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-group.edit', compact('ledgerGroup'));
    }

    public function show(LedgerGroup $ledgerGroup)
    {
        abort_if(Gate::denies('ledger_group_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.ledger-group.show', compact('ledgerGroup'));
    }
}
