<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\OInvoice;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Barryvdh\DomPDF\Facade\Pdf as BarryPDF;

class InvoiceController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('admin'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.invoices.index');
    }

    public function create()
    {
        abort_if(Gate::denies('admin'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.invoices.create');
    }

    public function edit(OInvoice $invoice)
    {
        abort_if(Gate::denies('admin'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.invoices.edit', compact('invoice'));
    }

    public function show(OInvoice $invoice)
    {
        abort_if(Gate::denies('admin'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $invoice->load('items', 'lastUpdatedBy');

        return view('admin.invoices.show', compact('invoice'));
    }
    public function delete(OInvoice $invoice)
    {
        abort_if(Gate::denies('admin'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $invoice->delete();
    }


    public function export(OInvoice $invoice)
    {

        $request = request();
        $mode = $request->get('mode', 'pdf');
        // $invoice load relations client,client.state, invoiceItems
        $invoice->load('client', 'client.state', 'items');
        $_get = function ($key) use ($invoice) {
            if ($key == 'gstin') {
                return $invoice->client->gstin;
            } elseif ($key == 'rhq_state') {
                if ($invoice->client && $invoice->client->state) {
                    return $invoice->client->state->name;
                }
            } elseif ($key == 'is_igst') {
                if ($invoice->client && $invoice->client->state) {
                    $input = ($invoice->client->state->name);
                    $lowercaseInput = strtolower($input);
                    $cleanedInput = preg_replace('/[^a-z]/', '', $lowercaseInput);
                    return !($cleanedInput === 'westbengal');
                }
            } elseif ($key == 'rhq_address') {
                return $invoice->client->rhq_address;
            } elseif ($key == 'rhq_phone') {
                return $invoice->client->rhq_phone;
            } elseif ($key == 'rhq_email') {
                return $invoice->client->rhq_email;
            } elseif ($key == 'inv_fin_year') {
                return $invoice->date ? self::getFinancialYearByDate($invoice->date) : null;
            }
            return $invoice->$key;
        };
        $is_igst_invoice = $_get("is_igst");

        $data = compact('invoice', '_get', 'is_igst_invoice');

        // return $pdf->download('invoice.pdf');
        if ($mode == 'pdf') {
            if ($invoice->isService) {
                $pdf = BarryPDF::loadView('prints.client-invoice-service-v1', $data)->setOptions([
                    'defaultFont' => 'sans-serif',
                    'isHtml5ParserEnabled' => true,
                    "enable_php" => true,
                    'isRemoteEnabled' => true,
                ])
                    ->setPaper('a4', 'landscape')
                    //
                ;
                return $pdf->stream();
            } elseif ($invoice->isTask) {
                $pdf = BarryPDF::loadView('prints.client-invoice-task-v1', $data)->setOptions([
                    'defaultFont' => 'sans-serif',
                    'isHtml5ParserEnabled' => true,
                    "enable_php" => true,
                    'isRemoteEnabled' => true,
                ])
                    ->setPaper('a4', 'landscape')
                    //
                ;
                return $pdf->stream();
            }
        } else {

            if ($invoice->isService) {
                return view('prints.client-invoice-service-v1', $data);
            } elseif ($invoice->isTask) {
                return view('prints.client-invoice-task-v1', $data);
            }

            return view('prints.client-invoice-v1', $data);
        }
    }


    // public static function to get financial year by date
    // public static function getFinancialYearByDate($date)
    // {
    //     // $date = '2019-01-01';
    //     $date = date('Y-m-d', strtotime($date));
    //     $month = date('m', strtotime($date));
    //     $year = date('Y', strtotime($date));
    //     if ($month < 4) {
    //         $year = $year - 1;
    //     }
    //     return $year;
    // }

    public static function getFinancialYearByDate($inputDate, $isShort = false)
    {
        // $inputDate = date_create_from_format('d/m/Y', $date);
        $year = intval(date_format($inputDate, 'Y'));
        $month = intval(date_format($inputDate, 'm'));

        if ($month < 4) {
            $startYear = $year - 1;
            $endYear = $year;
        } else {
            $startYear = $year;
            $endYear = $year + 1;
        }

        if ($isShort) {
            $startYear %= 100;
            $endYear %= 100;
        }

        $financialYear = ($isShort ? $startYear : $startYear . '-' . $endYear);

        return $financialYear;
    }
}
