<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\FinYr;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class FinYrController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = FinYr::class;
    }

    public function index()
    {
        abort_if(Gate::denies('fin_yr_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.fin-yr.index');
    }

    public function create()
    {
        abort_if(Gate::denies('fin_yr_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.fin-yr.create');
    }

    public function edit(FinYr $finYr)
    {
        abort_if(Gate::denies('fin_yr_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.fin-yr.edit', compact('finYr'));
    }

    public function show(FinYr $finYr)
    {
        abort_if(Gate::denies('fin_yr_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.fin-yr.show', compact('finYr'));
    }
}
