<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\EmployeeFamilyDetail;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class EmployeeFamilyDetailController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('employee_family_detail_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-family-detail.index');
    }

    public function create()
    {
        abort_if(Gate::denies('employee_family_detail_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-family-detail.create');
    }

    public function edit(EmployeeFamilyDetail $employeeFamilyDetail)
    {
        abort_if(Gate::denies('employee_family_detail_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.employee-family-detail.edit', compact('employeeFamilyDetail'));
    }

    public function show(EmployeeFamilyDetail $employeeFamilyDetail)
    {
        abort_if(Gate::denies('employee_family_detail_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $employeeFamilyDetail->load('employeeInfo');

        return view('admin.employee-family-detail.show', compact('employeeFamilyDetail'));
    }
}
