<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\Client;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClientController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = Client::class;
    }

    public function index()
    {
        abort_if(Gate::denies('client_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client.index');
    }

    public function create()
    {
        abort_if(Gate::denies('client_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client.create');
    }

    public function edit(Client $client)
    {
        abort_if(Gate::denies('client_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client.edit', compact('client'));
    }

    public function show(Client $client)
    {
        abort_if(Gate::denies('client_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $client->load('clientGroup', 'state');

        return view('admin.client.show', compact('client'));
    }
}
