<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\ClientBranch;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ClientBranchController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = ClientBranch::class;
    }

    public function index()
    {
        abort_if(Gate::denies('client_branch_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-branch.index');
    }

    public function create()
    {
        abort_if(Gate::denies('client_branch_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-branch.create');
    }

    public function edit(ClientBranch $clientBranch)
    {
        abort_if(Gate::denies('client_branch_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.client-branch.edit', compact('clientBranch'));
    }

    public function show(ClientBranch $clientBranch)
    {
        abort_if(Gate::denies('client_branch_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $clientBranch->load([
            // 'region',
        ]);

        return view('admin.client-branch.show', compact('clientBranch'));
    }
}
