<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CircleProductPivot;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CircleProductPivotController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('circle_product_pivot_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle-product-pivot.index');
    }

    public function create()
    {
        abort_if(Gate::denies('circle_product_pivot_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle-product-pivot.create');
    }

    public function edit(CircleProductPivot $circleProductPivot)
    {
        abort_if(Gate::denies('circle_product_pivot_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle-product-pivot.edit', compact('circleProductPivot'));
    }

    public function show(CircleProductPivot $circleProductPivot)
    {
        abort_if(Gate::denies('circle_product_pivot_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $circleProductPivot->load('product', 'circle', 'lastUpdatedBy');

        return view('admin.circle-product-pivot.show', compact('circleProductPivot'));
    }
}
