<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\Traits\WithCSVImport;
use App\Models\Circle;
use Gate;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class CircleController extends Controller
{
    use WithCSVImport;

    public function __construct()
    {
        $this->csvImportModel = Circle::class;
    }

    public function index()
    {
        abort_if(Gate::denies('circle_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle.index');
    }

    public function create()
    {
        abort_if(Gate::denies('circle_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle.create');
    }

    public function edit(Circle $circle)
    {
        abort_if(Gate::denies('circle_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.circle.edit', compact('circle'));
    }

    public function show(Circle $circle)
    {
        abort_if(Gate::denies('circle_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        // $circle->load('state');
        $circle->load('zone');

        return view('admin.circle.show', compact('circle'));
    }
}
